<?php

namespace App\Enums;

enum UserGender: int
{
    case MALE   = 0;
    case FEMALE = 1;

    /**
     * Get all gender values
     */
    public static function values(): array
    {
        return [
            self::MALE->value,
            self::FEMALE->value,
        ];
    }

    /**
     * Get gender name from enum
     */
    public static function genderName(self $gender): string
    {
        return match($gender) {
            self::MALE   => 'male',
            self::FEMALE => 'female',
        };
    }

    /**
     * Convert integer to gender string
     */
    public static function genderNameFromInt(int $value): string
    {
        return self::genderName(self::from($value));
    }

    /**
     * Get key-value pairs for dropdowns or display
     */
    public static function getKeyValuePairs(): array
    {
        return [
            [
                'value' => self::MALE->value,
                'key'   => __('main.attributes.male'),
            ],
            [
                'value' => self::FEMALE->value,
                'key'   => __('main.attributes.female'),
            ],
        ];
    }
}
