<?php

namespace App\Enums;

enum TypeOfRound: int
{
    case Offline = 0;
    case Online  = 1;
    case Hybrid  = 2;

    public static function values(): array
    {
        return [
            self::Offline->value,
            self::Online->value,
            self::Hybrid->value,
        ];
    }

    public static function labels(): array
    {
        return [
            self::Offline->value => 'offline',
            self::Online->value  => 'online',
            self::Hybrid->value  => 'hybrid',
        ];
    }

    public static function getKeyValuePairs(): array
    {
        return [
            ['value' => self::Offline->value, 'key' => 'Offline'],
            ['value' => self::Online->value,  'key' => 'Online'],
            ['value' => self::Hybrid->value,  'key' => 'Hybrid'],
        ];
    }
}
