<?php

namespace App\Enums;

enum SurveyQuestionType: string
{
    case TEXT = 'text';
    case TEXTAREA = 'textarea';
    case SELECT = 'select';
    case RADIO = 'radio';
    case CHECKBOX = 'checkbox';
    case RATING = 'rating';
    case DATE = 'date';
    case TIME = 'time';
    case EMAIL = 'email';
    case NUMBER = 'number';
    case URL = 'url';
    case FILE = 'file';
    case IMAGE = 'image';
    case SIGNATURE = 'signature';
    case MATRIX = 'matrix';
    case SCALE = 'scale';
    case RANKING = 'ranking';
    case NPS = 'nps';
    case SLIDER = 'slider';
    case STAR_RATING = 'star_rating';
    case HEAT_MAP = 'heat_map';
    case DROPDOWN = 'dropdown';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
    public static function getKeyValuePairs(): array
    {
        $pairs = [];
        foreach (self::cases() as $case) {
            $pairs[$case->value] = ucfirst(str_replace('_', ' ', $case->name));
        }
        return $pairs;
    }

    public static function isValid(string $value): bool
    {
        return in_array($value, self::values());
    }
}
