<?php

namespace App\Enums;

enum QuestionCategory: int
{
    case Listening            = 0;
    case Grammar              = 1;
    case Vocabulary           = 2;
    case GrammarAndVocabulary = 3;

    public static function values(): array
    {
        return [
            self::Listening->value,
            self::Grammar->value,
            self::Vocabulary->value,
            self::GrammarAndVocabulary->value,
        ];
    }

    public static function questionCategory(self $type): string
    {
        return match($type) {
            self::Listening            => 'listening',
            self::Grammar              => 'grammar',
            self::Vocabulary           => 'vocabulary',
            self::GrammarAndVocabulary => 'grammar_and_vocabulary',
        };
    }
    public static function getKeyValuePairs(): array
    {
        return [
            [
                'value' => self::Listening->value,
                'key'   => 'Listening',
            ],
            [
                'value' => self::Grammar->value,
                'key'   => 'Grammar',
            ],
            [
                'value' => self::Vocabulary->value,
                'key'   => 'Vocabulary',
            ],
            [
                'value' => self::GrammarAndVocabulary->value,
                'key'   => 'Grammar and Vocabulary',
            ],
        ];
    }
}