<?php

namespace App\Enums;

enum DefineStatus: int
{
    case ACTIVE   = 1;
    case INACTIVE = 0;

      /**
     * Get the default status (ACTIVE)
     */
    public static function default(): self
    {
        return self::ACTIVE;
    }

      /**
     * Get all the possible values as an array
     */
    public static function values(): array
    {
        return [
            self::ACTIVE->value,
            self::INACTIVE->value,
        ];
    }

      /**
     * Get available status types
     */
    public static function statusType(self $status): string
    {
        return match($status) {
            self::ACTIVE   =>  __('main.attributes.active'),
            self::INACTIVE => __('main.attributes.inactive'),
        };
    }

    public static function getKeyValuePairs(): array
    {
        return [
            [
                'value' => self::ACTIVE->value,
                'key'   => __('main.attributes.active'),
            ],
            [
                'value' => self::INACTIVE->value,
                'key'   => __('main.attributes.inactive'),
            ]
        ];
    }   
}