<?php

namespace App\Console\Commands;

use App\Models\ActivityLog;
use Carbon\Carbon;
use Illuminate\Console\Command;

class CleanupActivityLogs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'activity-logs:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove old activity logs based on retention period';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $retentionDays = config('activity_logs.retention_period.days');

        if (is_null($retentionDays)) {
            $this->info('Log retention is disabled. No logs were deleted.');
            return 0;
        }

        $cutoffDate = Carbon::now()->subDays($retentionDays);
        $deletedCount = ActivityLog::where('created_at', '<', $cutoffDate)->delete();

        $this->info("Deleted {$deletedCount} activity logs older than {$retentionDays} days.");

        return 0;
    }
}
